
````markdown
# Vol 1 — Toy-Model Casimir Construction

**Volume 1 of the Absolute Relativity Theory (v1)**

This repository symbolically constructs the discrete Casimir operator \(\hat Q\) from the core “tick” operators. Using the ansatz

\[
\hat Q \;=\; A\,(F\,S + S\,F)\;+\;\sum_{a=1}^{4} B_a\,\hat O_a^2
\]

we recover the invariant-interval form \((\Delta\tau)^2 + c^{-2}(\Delta x)^2\) in a 4×4 toy model.

---

## ✅ Evidence (SIM:V1-Casimir-001)

**Sanity check (Casimir):** max\(|I_2|\) ≤ 1e−3; observed **3.552713678800501e-15** over **N=2000** random orthogonal transforms (seed **20250819**) at commit `4f16e4a49b1100ef2d45df93cb3564837f8b8818`. **Pass.**  
[EVIDENCE: SIM:V1-Casimir-001]

**Provenance (pinned):**
- **Commit:** `4f16e4a49b1100ef2d45df93cb3564837f8b8818`
- **Run env:** Windows 10; Python 3.10.18; sympy 1.13.3; numpy 1.26.4
- **Artifacts & hashes:**
  - `results\casimir_coeffs.csv` — `sha256:b1e8fb142cc4a68ff5462fc0085b014c369373b6156a70cabed07654e6e422ad`
  - `results\i2_drift.json` — `sha256:4f7f5dc81fbe4cb51d7983f90ed833b7e7c4aa54cfa3aad897753ea8684fca56`

---

## Operators (notation)

- \( \hat F \): **Renewal** (outward flip)  
- \( \hat S \): **Sink** (inward flip)  
- \( \hat O_1,\dots,\hat O_4 \): basis projectors

> Note: This repo uses **F** (not **R**) to align with the canonical policy.

---

## Quick Start (Windows / Anaconda Prompt)

```bat
:: from repo root: vol1-casimir-operator
python solve_casimir.py

:: acceptance check (writes results\i2_drift.json)
python check_i2_drift.py --coeffs_csv results\casimir_coeffs.csv --trials 2000 --seed 20250819
````

**Outputs**

* `results\casimir_coeffs.csv`

  ```csv
  coeff,value
  B1,1.0
  B2,-1.0
  B3,1.0
  B4,-1.0
  ```
* `results\i2_drift.json` (sanity check summary for $I_2$ invariance)

---

## Repository Structure

```
vol1-casimir-operator/
├── README.md
├── LICENSE
├── requirements.txt    # sympy, numpy
├── solve_casimir.py    # main SymPy script
├── check_i2_drift.py   # acceptance check (I2 drift)
└── results/
    ├── casimir_coeffs.csv
    └── i2_drift.json
```

---

## License

MIT — see [LICENSE](LICENSE).

```

Updated from your uploaded README to use **F** (Renewal) instead of **R**, and to include your acceptance evidence. :contentReference[oaicite:0]{index=0}
```
